#ifndef _MAXtoATestOBJECT_H_
#define _MAXtoATestOBJECT_H_

#include <max.h>
#include <simpobj.h>
#include <iparamm2.h>

#include <MAXtoA_TranslationInterface.h>

#define MAXtoATestOBJECT_CLASS_ID Class_ID(0x6705faaa, 0xca131aaa)

class ClassDesc2;

using namespace Max::ArnoldTranslator;

class AtArray;
class MAXtoATestObject;

//==============================================================================
// class MAXtoATestObject_translationInterface
//==============================================================================

class MAXtoATestObject_translationInterface : public MAXtoA_TranslationInterface
{
    friend class MAXtoATestObject;

public:
    MAXtoATestObject_translationInterface(MAXtoATestObject* plugin);

    virtual Arnold_translation::TranslationInterface_Result Translate(INode* node,
        Arnold_translation* arnold_translation,
        const TimeValue translationTime,
        Interval& newValidity) override;

    virtual Arnold_translation::TranslationInterface_Result TranslateKeyframe(INode* node,
        const TimeValue frame_time,
        const TimeValue keyframe_time,
        unsigned int keyframe_index) override;

private:
    MAXtoATestObject* m_obj;
};


//==============================================================================
// class MAXtoATestObject
//==============================================================================
class MAXtoATestObject : public GeomObject 
{

    friend class MAXtoATestObject_translationInterface;

public:

    static ClassDesc2& GetClassDesc();

    void InitNodeName(MSTR & s);

    explicit MAXtoATestObject(bool loading);
    ~MAXtoATestObject();

    void SetBox(const Box3& box);
    void InvalidateMesh();
    void SetCreating(bool creating);

    void UpdateMesh(TimeValue t);

    bool DisplayAsWireframe();

	// -- from GeomObject
	virtual Mesh* GetRenderMesh(TimeValue t, INode *inode, View &view, BOOL& needDelete);

    // -- from Object
	virtual int IntersectRay(TimeValue t, Ray& ray, float& at, Point3& norm);		
	virtual ObjectState Eval(TimeValue time);
	//virtual void InitNodeName(TSTR& s) {s = GetObjectName();}
	virtual Interval ObjectValidity(TimeValue t);
	//virtual int CanConvertToType(Class_ID obtype);
	//virtual Object* ConvertToType(TimeValue t, Class_ID obtype);		
    //virtual BOOL PolygonCount(TimeValue t, int& numFaces, int& numVerts);
    
    // -- from BaseObject
	virtual void GetWorldBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box );
	virtual void GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box );
	virtual void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel );
    virtual CreateMouseCallBack* GetCreateMouseCallBack();
    virtual int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);
	virtual int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt);
	virtual void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt);
    virtual const TCHAR *GetObjectName();
	//virtual IParamArray *GetParamBlock();
	//virtual int GetParamBlockIndex(int id);

    // -- from ReferenceMaker
    virtual void RescaleWorldUnits(float f);
    virtual IOResult Save(ISave *isave);
    virtual IOResult Load(ILoad *iload);
    virtual RefResult NotifyRefChanged(const Interval& changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message, BOOL propagate);
    virtual int NumRefs();
    virtual RefTargetHandle GetReference(int i);
private:
    virtual void SetReference(int i, RefTargetHandle rtarg);
public:

    // -- from ReferenceTarget
    virtual RefTargetHandle Clone(RemapDir &remap);
        
    // -- from Animatable
    virtual void DeleteThis();
    virtual void BeginEditParams(IObjParam  *ip, ULONG flags,Animatable *prev);
    virtual void EndEditParams(IObjParam *ip, ULONG flags,Animatable *nex);
    virtual int NumParamBlocks();
    virtual IParamBlock2* GetParamBlock(int i);
    virtual IParamBlock2* GetParamBlockByID(short id);
    virtual void FreeCaches();
    virtual void GetClassName(TSTR& s);
    virtual SClass_ID SuperClassID();
    virtual Class_ID ClassID();

	// -- from InterfaceServer
	virtual BaseInterface* GetInterface(Interface_ID id);

	// from IDisplay
	unsigned long GetObjectDisplayRequirement() const;

	bool PrepareDisplay(
		const MaxSDK::Graphics::UpdateDisplayContext& prepareDisplayContext);
	bool UpdatePerNodeItems(
		const MaxSDK::Graphics::UpdateDisplayContext& updateDisplayContext,
		MaxSDK::Graphics::UpdateNodeContext& nodeContext,
		MaxSDK::Graphics::IRenderItemContainer& targetRenderItemContainer);

    // Apply the up axis change
    virtual void ApplyUpAxis();

    void GeneratePts(const int n);

private:
    int m_recursion;

	class UserDlgProc;

    enum RefID {
        kRef_MainPB = 0,

        kNumRefs
    };

    // Param block IDs
    enum ParamBlockID {
        kMainPBID = 0,
    };

    // Parameter IDs for main param block
    enum MainPBParamID {
        nb_curves = 0,
    };

    enum ChunkID {
        kChunk_Box = 0x0011
    };

    void BuildMesh(TimeValue t);

    ////////////////////////////////////////////////////////////////////////////
    // Data members
    ////////////////////////////////////////////////////////////////////////////

    static ParamBlockDesc2 m_mainPBDesc;

    // The bounding box of the object (used to generate the mesh)
    Box3 m_box;

    IParamBlock2* m_mainPB;

    Mesh m_mesh;
    Interval m_meshValid;

    // In the creation process?
    bool m_creating;

    MAXtoATestObject_translationInterface m_ti;

    std::vector<Point3> m_pts;

    AtNode* m_curves;
    AtArray* m_nbPoints;
    AtArray* m_points;
    AtArray* m_curvesRadius;
};


//==============================================================================
// class ArnoldProceduralObject inlined methods
//==============================================================================

inline void MAXtoATestObject::SetBox(const Box3& box) 
{
    m_box = box;
}

inline void MAXtoATestObject::InvalidateMesh() 
{
    m_meshValid.SetEmpty();
}

inline void MAXtoATestObject::SetCreating(bool creating) 
{
    m_creating = creating;
}

#endif
